/* This file describes a group of controls for output cellsizes for any given application.
   It consists of 
   - A label
   - Two textnumbers
   - a popuplist
   
   The recommended minimum size of this group is 460 by 35 (width, height).
   
   Change of values will expose the following functions:
   - update_xcellsize()
   - update_ycellsize()
   - update_cell_units()
*/


info "Output image pixel size";
lock left, top, width, height;
bordertype etched_in;
label outputcelllabel {
	title left center "Output Cell Sizes";
	geometry 5, 0, 90, 28;
}
textnumber xcellsize {
	title left center "X:";
	info "The Default Output X Cell Size";
	geometry 100, 0, 120, 28;
	min .00000001;
	max 100000000000;
	format "14.8";
	on valuechanged {
		update_xcellsize ();
	}
}
textnumber ycellsize {
	title left center "Y:";
	info "The Default Output Y Cell Size";
	geometry 230, 0, 120, 28;
	min .00000001;
	max 1000000000000;
	format "14.8";
	on valuechanged {
		update_ycellsize ();
	}
}

popuplist cellunits {
	info "Cell size units";
	geometry 360, 0, 90, 28;
	on valuechanged {
		update_cell_units ();
	}
}
